<!DOCTYPE html>
<?php
session_start();
if (isset($_SESSION['email'])) {
    header('Location: otp.php');
    exit;
}
?>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Halaman Login</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript">
        function validateForm() {
            const password = document.getElementById("password").value;
            const confirmPassword = document.getElementById("confirm_password").value;

            if (password !== confirmPassword) {
                alert("Password tidak cocok!");
                return false;
            }
            return true;
        }
    </script>
</head>

<body>
    <div class="container-fluid">
        <form class="form-daftar" action="regist.php" method="post" onsubmit="return validateForm()">
            <div class="row justify-content-center align-items-center vh-100">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header text-center">
                            <h3>Daftar</h3>
                        </div>
                        <?php
                        if (isset($_SESSION['error'])) {
                            echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <strong>Gagal,</strong> ' . $_SESSION['error'] . '
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                  </div>';
                            unset($_SESSION['error']);
                        }
                        ?>
                        <?php
                        session_unset();
                        ?>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" id="email"
                                    placeholder="Masukkan email" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" name="password" id="password"
                                    placeholder="Masukkan password" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Konfirmasi Password</label>
                                <input type="password" class="form-control" name="confirm_password"
                                    id="confirm_password" placeholder="Masukkan password" required>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">Daftar</button>
                            <p>Sudah punya akun? <a href="index.php">login</a></p>
                        </div>
                    </div>
                </div>
            </div>
            <p class="text-center">&copy;2025</p>
        </form>

    </div>
</body>

</html>